/*
 * This file is part of cchttpd.
 * Copyright (C) 2013-2014  Guillaume Quintin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _CCHTTPD_H
#define _CCHTTPD_H

/* cchttpd.c */
const char *relative_path(const char*);
void exit2(int,conn*);
void assert2(int,const char*);
void proceed(int,int,int,const char*);
int main(int,char**);

/* get_method.c */
int fgetc2(conn*);
void empty_input(conn*);
void check_get_method(conn*);
int hex2int(int);
void do_get_method(conn*);

/* init.c */
void init(int,char**);

/* logger.c */
void flock2(FILE*);
void funlock2(FILE*);
void logger(int,conn*,const char*,...);

/* mime.c */
char *get_mime_type(const char*);

/* mycgi.c */
void do_cgi(conn*,const char*);
void check_cgi(conn*,const char*);

/* send.c */
void send_exit_conn_closed(int,conn*);
void fflush2(conn*,FILE*);
void fputs2(const char*,FILE*,conn*);
void fprintf2(conn*,FILE*,const char*,...);
void send_headers(conn*,const char*,const char*,const char*,
                  unsigned long);
void send_redirect(conn *c,const char*);
void send_not_implemented(conn*);
void send_not_found(conn*);
void send_bad_request(conn*);
void send_internal_error(conn*);
void send_uri_too_long(conn*);
void try_send_file(conn*,const char*);
unsigned long sz_kb(unsigned long);
unsigned long log10_sz_kb(unsigned long);
void try_list_dir(conn*,const char*);

/* signals.c */
void handle_sigchld(int);
void init_signals(void);
int sig_default(void);

/* socket.c */
void do_daemonize(void);
void accept_connection(int,int,const char*);
void daemon_main_loop(void);

#endif
