##
This file is part of cchttpd.
Copyright (C) 2012-2014  Guillaume Quintin.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
##

==NAME==

cchttpd - a very simple http server which supports only GET

==SYNOPSIS==

`cchttpd` [ `-d` ] [ `-v` ] [ `-vv` ]
[ `-u` `username` ] [ `-g` `groupname` ] [ `-h` `dir` ]
[ `-ip` `address` ] [ `-p` `port` ] [ `-t` `timeout` ]
[ `-log` `logfile` ] [ `--` `URI` `=` `script` `...` ]

==DESCRIPTION==

`Cchttpd` is a very simple and lightweight http server for your
website whose root is located at `dir`. It only supports the GET
method. It waits requests on the standard input and reponds on the
standard output. It can be used with `inetd`(8) in order to respond
to network requests. Suppose that you have installed `cchttpd` in
`/usr/bin` and that the root of your website is `/var/www`. Just put
in your `inetd.conf` the following.

``
http stream tcp nowait nobody /usr/bin/cchttpd cchttpd /var/www
``

Make sure that your `/etc/service`(5) file contains a line
about `http`.

``
http    80/tcp       # WorldWideWeb HTTP
``

When the client requests a resource correspoding to a directory on the
server, `cchttpd` will send back the listing of the directory ignoring
all files that it cannot open and files beginning with a '`.`'. If
`cchttpd` cannot open the directory at all, whatever the reason is, it
responds with error `404, Not Found`.

===USE CCHTTPD AS A DAEMON===

`Cchttpd` can also be used as a stand-alone server. Here is how it
works. On every incoming connexion `cchttpd` forks so that each
client (or connexion) is handled by a separate process. `Cchttpd`
is *not* intended to be used for big websites. But, even for a
personal website hosted on your personal
computer at your home where your ISP gives you a ridiculous upload,
the retrieval of a large file (say a few MB) can take time. And
during this retrieval time you do not want your website to be off,
hence the fork stuff.

===OPTIONS===

> `-d`
  Daemonize `cchttpd`.

> `-v`, `-vv`
  Increase the verbosity of `cchttpd`.
  By default all errors and informations on the functionning
  of `cchttpd`are logged. With `-v` all informations concerning
  the connexions are logged. With `-vv` a lot of stuff is logged
  mainly for debugging purpose.

> `-u` `username`
  This option, along with `-g`, can be used for privilege dropdown,
  `username` must be a valid user of the system, for example user
  `nobody`.

> `-g` `groupname`
  This option, along with `-u`, can be used for privilege dropdown,
  `groupname` must be a valid group of the system, for example group
  `nogroup`.

> `-h` `dir`
  Set the root dir of your website to be `dir`.

> `-t` `timeout`
  Set the timeout for incomming connection to `timeout`. It must be
  an integer between `0` and `3600` representing seconds. A timeout
  of `0` indicates no timeout. By default the timeout is 5 seconds.

> `-ip` `address`
  Listen for incoming connexions on the local IP address `address`.

> `-p` `port`
  Listen for incoming connexions on port `port`.

> `-log` `logfile`
  All log messages of `cchttpd` wil go to `logfile`.
  By default all log messages go to `stderr`.

===GENERATED PAGES===

Some webpages need to be generated when requested by a client.
`Cchttpd` allows this kind of webpages. Every time a client requests
`URI`, `cchttpd` executes `script` which must send the content of
the page onto standard output. `Script` must also send the HTTP
headers via standard output. It is *strongly* recommanded that
the HTTP headers look like

``
HTTP/1.1 200 OK
Server: cchttpd
Content-Type: mime/type
Content-Length: size
Connection: close

[ real content here]
``

where `mime/type` must be a valid MIME type and `size` must be
the actual size in bytes of the content you want to send. Also
do not forget that new lines must be encoded with `\\r\\n`.
Note that `script` does not have any information about the
IP address or the URI requested by the client that caused
`script` to be executed. `Cchttpd` does not support any POST
method. Standard input and standard error for `script` are redirected
to `/dev/null`.

==SEE ALSO==

`inetd`(8),`services`(5).

==AUTHOR==

Written by Guillaume Quintin (coincoin169g@gmail.com).

