/*
 * This file is part of cchttpd.
 * Copyright (C) 2012-2014  Guillaume Quintin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* we define our own fgetc, so that it dies if it encounters EOF
   which is always unexpected. */
int fgetc2(conn *c) {
  int b;
  b = fgetc(c->in);
  if ( b == EOF ) exit2(EXIT_SUCCESS,c);
  return b;
}

/* we eat what's left (until we find a \r\n\r\n) */
void empty_input(conn *c) {
  char buf[4];
  buf[0] = fgetc2(c);
  buf[1] = fgetc2(c);
  buf[2] = fgetc2(c);
  buf[3] = fgetc2(c);
  for(;;) {
    if ( !memcmp(buf,"\r\n\r\n",4) ) return;
    buf[0] = buf[1];
    buf[1] = buf[2];
    buf[2] = buf[3];
    buf[3] = fgetc2(c);
  }
}

void check_get_method(conn *c) {
  char method[4];
  method[0] = (char)fgetc2(c);
  method[1] = (char)fgetc2(c);
  method[2] = (char)fgetc2(c);
  method[3] = (char)fgetc2(c);
  if ( memcmp(method,"GET ",4) ) {
    empty_input(c);
    send_not_implemented(c);
    exit2(EXIT_SUCCESS,c);
  }
}

int hex2int(int b) {
  if ( b >= '0' && b <= '9' ) return (b - '0');
  if ( b >= 'a' && b <= 'f' ) return (10 + b - 'a');
  if ( b >= 'A' && b <= 'F' ) return (10 + b - 'A');
  return -1;
}

#define INDEX_TRY_1 "index.html"
#define INDEX_TRY_2 "index.htm"
#define INDEX_TRY_3 "index.txt"

void do_get_method(conn *c) {
  char file[LEN + 20];
  struct stat buf;
  int n;

  /* Get the URI */
  for( n = 0 ; n < LEN ; n++ ) {
    int b;
    b = fgetc2(c);
    switch(b) {
      case '%': {
        int u,l;
        u = hex2int(fgetc2(c));
        l = hex2int(fgetc2(c));
        if ( u == -1 || l == -1 ) {
          empty_input(c);
          send_bad_request(c);
          exit2(EXIT_SUCCESS,c);
        }
        file[n] = 16 * u + l;
        break;
      }
      case ' ':
        file[n] = 0;
        break;
      default:
        file[n] = (char)b;
        break;
    }
    if ( (n == 3 && !memcmp(&file[0],"../",3) ) ||
         (n == 2 && !memcmp(&file[0],"./",2) ) ||
         (n > 4 && !memcmp(&file[n - 4],"/../",4) ) ||
         (n > 3 && !memcmp(&file[n - 4],"/./",3) ) ||
         (b == ' ' && n > 4 && !memcmp(&file[n - 4],"/..",4) ) ||
         (b == ' ' && n > 3 && !memcmp(&file[n - 3],"/.",3) ) ||
         (b == ' ' && n == 3 && !memcmp(&file[0],"..",3) ) ||
         (b == ' ' && n == 2 && !memcmp(&file[0],".",2) ) )
    {
      empty_input(c);
      send_bad_request(c);
      exit2(EXIT_SUCCESS,c);
    }
    if ( b == ' ' ) break;
  }
  empty_input(c);
  if ( n == LEN ) {
    send_uri_too_long(c);
    exit2(EXIT_SUCCESS,c);
  }
  if ( n == 0 ) {
    send_bad_request(c);
    exit2(EXIT_SUCCESS,c);
  }
  logger(V_LOG_CONN,c,"requested resource: %s",file);

  /* First check for CGI stuff */
  check_cgi(c,file);

  /* If the URI is not "/", check if the clients
     wants a dir whose URI MUST finish by "/"
     otherwise it gets a redirection (301). */
  if ( file[0] != '/' || file[1] != 0 ) {
    if ( stat(relative_path(file),&buf) ) {
      send_not_found(c);
      exit2(EXIT_SUCCESS,c);
    }
    if ( S_ISDIR(buf.st_mode) && file[n - 1] != '/' ) {
      file[n] = '/';
      file[n + 1] = 0;
      send_redirect(c,file);
      exit2(EXIT_SUCCESS,c);
    }
  }

  /* Try to satisfy the client by sending it the file
     or the directory listing. */
  if ( file[n - 1] == '/' ) {
    memcpy(&file[n],INDEX_TRY_1,sizeof(INDEX_TRY_1) + 1);
    try_send_file(c,file);
    memcpy(&file[n],INDEX_TRY_2,sizeof(INDEX_TRY_2) + 1);
    try_send_file(c,file);
    memcpy(&file[n],INDEX_TRY_3,sizeof(INDEX_TRY_3) + 1);
    try_send_file(c,file);
    file[n] = 0;
    try_list_dir(c,file);
    send_not_found(c);
    exit2(EXIT_SUCCESS,c);
  }
  else {
    try_send_file(c,file);
    send_not_found(c);
    exit2(EXIT_SUCCESS,c);
  }
}

