/*
 * This file is part of cchttpd.
 * Copyright (C) 2013-2014  Guillaume Quintin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

void init(int argc,char **argv) {
  int i;
  if ( gethostname(hostname,BUF_LEN) ) {
    strcpy(hostname,"(none)");
  }
  main_conn.in = NULL;
  main_conn.out = NULL;
  main_conn.err = stderr;
  main_conn.ip[0] = 0;
  home = getenv("PWD");
  daemonize = 0;
  verbose = V_LOG_SVR;
  argc2 = argc;
  argv2 = argv;
  port = 80;
  ip = "0.0.0.0";
  uid = getuid();
  gid = getgid();
  as_server = 0;
  children = 0;
  read_timeout = 5;
  for( i = 1 ; i < argc ; i++ ) {
    if ( !strcmp(argv[i],"--") ) break;
    if ( !strcmp(argv[i],"-d") ) {
      daemonize = 1;
      as_server = 1;
    }
    if ( !strcmp(argv[i],"-v") ) verbose = V_LOG_CONN;
    if ( !strcmp(argv[i],"-vv") ) verbose = V_DEBUG;
    if ( !strcmp(argv[i],"-u") ) {
      struct passwd *p;
      i++;
      assert2((i < argc),"no username given after -u");
      p = getpwnam(argv[i]);
      assert2((p != NULL),"wrong username");
      uid = p->pw_uid;
      as_server = 1;
    }
    if ( !strcmp(argv[i],"-g") ) {
      struct group *g;
      i++;
      assert2((i < argc),"no groupname given after -g");
      g = getgrnam(argv[i]);
      assert2((g != NULL),"wrong groupname");
      gid = g->gr_gid;
      as_server = 1;
    }
    if ( !strcmp(argv[i],"-p") ) {
      i++;
      assert2((i < argc),"no port given after -p");
      port = atoi(argv[i]);
      as_server = 1;
    }
    if ( !strcmp(argv[i],"-h") ) {
      i++;
      assert2((i < argc),"no rootdir given after -h");
      home = argv[i];
    }
    if ( !strcmp(argv[i],"-t") ) {
      i++;
      assert2((i < argc),"no delay given after -t");
      read_timeout = atoi(argv[i]);
      assert2(read_timeout >= 0 && read_timeout <= 3600,
              "delay must be between 0 and 3600 seconds");
    }
    if ( !strcmp(argv[i],"-ip") ) {
      i++;
      assert2((i < argc),"no ip address given after -ip");
      ip = argv[i];
      if ( strcmp(ip,"0.0.0.0") ) {
        assert2((inet_addr(ip) != INADDR_NONE),
                "invalid IP address given");
      }
      as_server = 1;
    }
    if ( !strcmp(argv[i],"-log") ) {
      FILE *tmp;
      i++;
      assert2((i < argc),"no log file given after -log");
      tmp = fopen(argv[i],"a");
      assert2((tmp != NULL),"cannot open log file");
      main_conn.err = tmp;
    }
  }
}

