/*
 * This file is part of cchttpd.
 * Copyright (C) 2012-2014  Guillaume Quintin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

void flock2(FILE *f) {
  struct flock lock;
  lock.l_start = 0;
  lock.l_whence = SEEK_SET;
  lock.l_len = 0;
  lock.l_pid = getpid();
  lock.l_type = F_WRLCK;
  for(;;) {
    int r;
    r = fcntl(fileno(f),F_SETLKW,&lock);
    if ( r == -1 && errno == EINTR ) continue;
    break;
  }
}

void funlock2(FILE *f) {
  struct flock lock;
  lock.l_start = 0;
  lock.l_whence = SEEK_SET;
  lock.l_len = 0;
  lock.l_pid = getpid();
  lock.l_type = F_UNLCK;
  for(;;) {
    int r;
    r = fcntl(fileno(f),F_SETLKW,&lock);
    if ( r == -1 && errno == EINTR ) continue;
    break;
  }
}

void logger(int lvl,conn *c,const char *format,...) {
  unsigned long pid;
  FILE *err;
  time_t t_now;
  char *asc_now,*lf;
  va_list ap;
  int errno2;

  if ( lvl > verbose || c->err == NULL ) return;
  errno2 = errno; /* so that it is not modified by what's below */
  err = c->err;
  t_now = time(NULL);
  asc_now = asctime(localtime(&t_now));
  lf = strchr(asc_now,'\n');
  if ( lf ) lf[0] = 0;
  pid = getpid();
  flock2(err);
  if ( c->ip[0] == 0 ) {
    fprintf(err,"%s %s cchttpd[%lu]: ",asc_now,hostname,pid);
  }
  else {
    fprintf(err,"%s %s cchttpd[%lu]: %s: ",
            asc_now,hostname,pid,c->ip);
  }
  va_start(ap,format);
  vfprintf(err,format,ap);
  va_end(ap);
  fputc('\n',err);
  if ( lvl == V_ERR ) {
    if ( c->ip[0] == 0 ) {
      fprintf(err,"%s %s cchttpd[%lu]: error %d: %s\n",
              asc_now,hostname,pid,errno2,strerror(errno2));
    }
    else {
      fprintf(err,"%s %s cchttpd[%lu]: %s: error %d: %s\n",
              asc_now,hostname,pid,c->ip,errno2,strerror(errno2));
    }
  }
  fflush(err);
  funlock2(err);
}
