/*
 * This file is part of cchttpd.
 * Copyright (C) 2012-2013  Guillaume Quintin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

char *get_mime_type(const char *file) {
  char *dot,*ext;
  dot = strrchr(file,'.');
  if ( dot == NULL ) return "application/octet-stream";
  ext = &dot[1];
  if ( !strcmp(ext,"c") || !strcmp(ext,"h") ||
       !strcmp(ext,"cc") || !strcmp(ext,"cpp") ||
       !strcmp(ext,"hpp") || !strcmp(ext,"txt") ||
       !strcmp(ext,"conf") || !strcmp(ext,"text") )
  {
    return "text/plain";
  }
  if ( !strcmp(ext,"html") || !strcmp(ext,"htm") ) {
    return "text/html";
  }
  if ( !strcmp(ext,"css" ) ) return "text/css";
  if ( !strcmp(ext,"jpg") || !strcmp(ext,"jpeg") ) {
    return "image/jpeg";
  }
  if ( !strcmp(ext,"png") ) return "image/png";
  if ( !strcmp(ext,"gif") ) return "image/gif";
  if ( !strcmp(ext,"zip") ) return "application/zip";
  if ( !strcmp(ext,"tgz") ) return "application/x-tgz";
  if ( !strcmp(ext,"gz") ) return "application/gzip";
  if ( !strcmp(ext,"bz2") ) return "application/x-bzip2";
  if ( !strcmp(ext,"torrent") ) return "application/x-bittorrent";
  return "application/octet-stream";
}

