/*
 * This file is part of cchttpd.
 * Copyright (C) 2013-2014  Guillaume Quintin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

void do_cgi(conn *c,const char *cmd) {
  int fd;
  fd = fileno(c->out);
  if ( fd == -1 ) {
    logger(V_ERR,c,"invalid file descriptor, weird!");
    send_internal_error(c);
    exit2(EXIT_SUCCESS,c);
  }
  
  { /* We dup2 stdin and stderr to /dev/null */
    int in,newin,err,newerr;
    in = open(DEV_NULL,O_RDONLY);
    err = open(DEV_NULL,O_WRONLY);
    if ( in < 0 || err < 0 ) {
      logger(V_ERR,c,"cannot open " DEV_NULL " for read/write");
      exit2(EXIT_SUCCESS,c);
    }
    newin = dup2(in,0);
    newerr = dup2(err,2);
    if ( newin < 0 || newerr < 0 ) {
      logger(V_ERR,c,"cannot dup " DEV_NULL);
      exit2(EXIT_SUCCESS,c);
    }
    if ( close(in) < 0 || close(err) < 0 ) {
      logger(V_ERR,c,"cannot close stdin and stderr");
      exit2(EXIT_SUCCESS,c);
    }
  }

  if ( fd != 1 ) { /* We also dup2 stdout to out */
    int newout;
    newout = dup2(fd,1);
    if ( newout < 0 || close(fd) < 0 ) {
      logger(V_ERR,c,"cannot set stdout properly");
      exit2(EXIT_SUCCESS,c);
    }
  }

  /* exec cmd to serve the client */
  logger(V_DEBUG,c,"execlp(\"%s\")",cmd);
  execlp(cmd,cmd,NULL);
  exit2(EXIT_SUCCESS,c);
}

void check_cgi(conn *c,const char *file) {
  int i;

  /* looking for the -- */
  for( i = 0 ; i < argc2 && strcmp(argv2[i],"--") ; i++ );
  if ( i >= argc2 ) return;

  /* cchttpd home -- /aa = aa.sh -- /bb = bb.sh  */
  for( ; i < argc2 ; i += 4 ) {
    if ( i + 3 >= argc2 ||
         strcmp(argv2[i],"--") ||
         strcmp(argv2[i + 2],"=") )
    {
      logger(V_ERR,c,"error in the invokation of cchttpd");
      send_internal_error(c);
      exit(0);
    }
    if ( !strcmp(argv2[i + 1],file) ) {
      logger(V_LOG_CONN,c,
             "mycgi: correspondance found: %s -> %s",
             file,argv2[i + 3]);
      do_cgi(c,argv2[i + 3]);
    }
  }
}
