/*
 * This file is part of cchttpd.
 * Copyright (C) 2013  Guillaume Quintin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

void sigpipe_write(char c) {
  int try,w;
  for( try = 10 ; try > 0 ; try-- ) {
    w = write(sigpipe[1],&c,1);
    if ( w == 1 ) return;
    if ( w == 0 || (w == -1 && errno == EINTR) ) continue;
    break;
  }
}

void sigchld_handler(int s) {
  if ( s != SIGCHLD ) return;
  sigpipe_write('c');
}

void sigterm_handler(int s) {
  if ( s != SIGTERM && s != SIGINT ) return;
  sigpipe_write('t');
}

void init_signals(void) {
  struct sigaction act;
  act.sa_handler = sigchld_handler;
  act.sa_flags = 0;
  sigfillset(&act.sa_mask);
  assert2((sigaction(SIGCHLD,&act,NULL) == 0),
          "Cannot set handler for SIGCHLD");
  act.sa_handler = sigterm_handler;
  assert2((sigaction(SIGTERM,&act,NULL) == 0),
          "Cannot set handler for SIGTERM");
  act.sa_handler = sigterm_handler;
  assert2((sigaction(SIGINT,&act,NULL) == 0),
          "Cannot set handler for SIGINT");
}

int sig_default(void) {
  return ( signal(SIGCHLD,SIG_DFL) == SIG_ERR ||
           signal(SIGTERM,SIG_DFL) == SIG_ERR ||
           signal(SIGINT,SIG_DFL) == SIG_ERR );
}

