/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

void bool_func_print(FILE *out,struct bool_func *f) {
  uma i;
  
  if ( f->nmo == 0 ) {
    fputc('0',out);
    return;
  }
  fputs("  ",out);
  monomial_print(out,f->mo[0]);
  for( i = 1 ; i < f->nmo ; i++ ) {
    fputs("\n+ ",out);
    monomial_print(out,f->mo[i]);
  }
}

struct bool_func *bool_func_read(FILE *in) {
  uma i,nmo,nvar,r;
  monomial *mo,*tmp,np;
  struct bool_func *f;

  f = malloc2(sizeof(struct bool_func));
  if ( !f ) return NULL;
  nvar = 0;
  nmo = 32;
  mo = malloc2(nmo * sizeof(monomial));
  if ( mo == NULL ) goto bool_func_read_free_f;
  for( i = 0 ; ; i++ ) {
    r = monomial_read(&np,in);
    if ( r == -1 ) break;
    if ( r < -1 ) goto bool_func_read_free_mo;
    nvar = MAX(nvar,r);
    if ( i == nmo ) {
      nmo = nmo * 2;
      tmp = realloc2(mo,nmo * sizeof(monomial));
      if ( tmp == NULL ) goto bool_func_read_free_mo;
      mo = tmp;
    }
    mo[i] = np;
  }
  nmo = i;
  if ( nmo == 0 ) goto bool_func_read_free_mo;
  tmp = realloc2(mo,nmo * sizeof(monomial));
  if ( !tmp ) goto bool_func_read_free_mo; 
  mo = tmp;
  f->nvar = nvar;
  f->nmo = nmo;
  f->mo = mo;
  return f;

bool_func_read_free_mo:
  free2(mo);

bool_func_read_free_f:
  free2(f);
  
  return NULL;
}

void bool_func_free(struct bool_func *f) {
  if ( f->mo ) free2(f->mo);
  free2(f);
}

bit bool_func_eval(struct bool_func *f,tuple a) {
  uma i;
  bit ret;

  ret = zero;
  for( i = 0 ; i < f->nmo ; i++ ) {
    ret ^= monomial_eval(f->mo[i],a);
  }
  return ret;
}

struct points *bool_func_get_fiber_over_1(struct bool_func *f) {
  struct points *pts;
  tuple i,max,*tmp;
  uma npt;

  pts = malloc2(sizeof(struct points));
  if ( !pts ) return NULL;
  max = (~zero) >> (__MONOMIAL - f->nvar);
  tmp = calloc2(max + 1,sizeof(tuple));
  if ( !tmp ) goto bool_func_get_fiber_over_1_free_pts;
  npt = 0;
  for( i = zero ; i <= max ; i++ ) {
    if ( bool_func_eval(f,i) == one ) {
      tmp[npt] = i;
      npt++;
    }
  }
  pts->pt = adjust2(tmp,npt * sizeof(tuple));
  pts->npt = npt;
  pts->nvar = f->nvar;
  return pts;

bool_func_get_fiber_over_1_free_pts:
  free2(pts);

  return NULL;
}

int bool_func_get_ai(struct bool_func_ai_stats *t,struct bool_func *f,
                     int order)
{
  struct points *pts;
  uma ret;
  clock_t start,end;

  /* compute the fiber over 1 */
  start = clock();
  pts = bool_func_get_fiber_over_1(f);
  if ( !pts ) return -1;
  end = clock();
  if ( t ) t->fiber = end - start;

  /* compute the AI */
  if ( t ) start = clock();
  ret = main_algo(pts,order);
  points_free(pts);
  end = clock();
  if ( t ) t->ai = end - start;

  return (int)ret;
}

int bool_func_get_ai_ex(struct bool_func_ai_stats *t,
                        struct bool_func *f,int order,
                        int algo,unsigned long mem)
{
  struct points *pts;
  uma ret;
  clock_t start,end;

  /* compute the fiber over 1 */
  start = clock();
  pts = bool_func_get_fiber_over_1(f);
  if ( !pts ) return -1;
  end = clock();
  if ( t ) t->fiber = end - start;

  /* compute the AI */
  if ( t ) start = clock();
  ret = main_algo_ex(pts,order,algo,mem);
  points_free(pts);
  end = clock();
  if ( t ) t->ai = end - start;

  return (int)ret;
}

int bool_func_get_ai_pts(struct bool_func_ai_stats *t,
                         struct points *pts,int order)
{
  uma ai;
  clock_t start,end;

  if ( t ) t->fiber = 0;
  start = clock();
  ai = main_algo(pts,order);
  end = clock();
  if ( t ) t->ai = end - start;
  return (int)ai;
}

int bool_func_get_ai_pts_ex(struct bool_func_ai_stats *t,
                            struct points *pts,int order,
                            int algo,unsigned long mem)
{
  uma ai;
  clock_t start,end;

  if ( t ) t->fiber = 0;
  start = clock();
  ai = main_algo_ex(pts,order,algo,mem);
  end = clock();
  if ( t ) t->ai = end - start;
  return (int)ai;
}
