##
This file is part of decoding
Copyright (C) 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
##

==OVERVIEW==

This page describes how to build the library and how to
install it. In many cases it is sufficient to
type `make && make install` in the root directory of `imunal`
to build and install it. If it does not work please read the
following.

==DESCRIPTION==

The `imunal` library is written in C89 and should
therefore be build without trouble by any C compiler
which supports strict C89. The library has been tested
on several linux distributions and on Mac OS.

- Debian 7.0 (64 bits)

- Scientific Linux 6.3 (64 bits)

- Mac OS X v10.6.8 (64 bits)

===HOW TO BUILD THE LIBRARY?===

As of now, no Makefile-building system is available.
Fortunately there is not dependencies for building `imunal`.
In fact reading the `Makefile` should be sufficient to do all you
have/want to do to build and install the library and you can skip
this page.

Otherwise, when you have decompressed the library,
the beginning of the `Makefile` looks like:

``
\############################################################
#
# Installation directories
#
\############################################################

LIB_DIR     = /usr/lib
BIN_DIR     = /usr/bin
INCLUDE_DIR = /usr/include
MAN_DIR     = /usr/share/man
``

Once you will have modified the `Makefile` to suit your needs
simply type

``
make
``

to build the library and then

``
make install
``

to install the library. It is recommended to do `make check`
before using the library.

===INSTALLATION===

The library binary files go, by default, into `/usr/lib`,
the header files go into `/usr/include` the `imunal` executable
go into `/usr/bin` and the manpages go into `/usr/share/man`.
You can of course install `imunal` files where you want. You simply
have to modify the `Makefile`.

``
LIB_DIR     = /usr/lib
BIN_DIR     = /usr/bin
INCLUDE_DIR = /usr/include
MAN_DIR     = /usr/share/man
``

The `LIB_DIR` variable determines where the binary files
of the library will be installed.
The `BIN_DIR` variable determines where the binary files
of the imunal executable will be installed.
The `INCLUDE_DIR` variable determines where the header files
will be installed.
The `MAN_DIR` variable determines where the manpages will be
installed.

===USING IMUNAL WITH C++===

The library can be used by any C++ program. Just build the library
as described above. You are then free to use it as any C library
with a C++ program. The way to use the library does not change.

==AUTHOR==

Written by Guillaume Quintin (guillaume.quintin@unilim.fr).
