##
Copyright (C) 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
This file is part of imunal

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
##

==NAME==

imunal - a program that computes the algebraic immunity of boolean
functions

==SYNOPSIS==

`imunal` [ `--version` |
... [`-v` | `-q` | `FILE` | `-majority` `n`] ... ]

==DESCRIPTION==

`Imunal` is a program that computes the algebraic immunity (AI) of
boolean functions. The boolean function whose AI is to computed
must be given of the following form.

``
M0 + M1 + M2 + ... + Mn
``

Each `Mi` is either `1` or a form where the variables must be `x1`,
`x2`... All the variables within a form must not be separated by any
character. For example `x1x2x3` is a valid form whereas
`x1 x2x3` and `x1x2 x3` are not valid forms. A valid boolean
function is given as an example below.

``
1 + x1x2 + x2x3 + x3x4 + x4x5
``

Note that between forms, spaces, line feeds, tabs, '+' characters
can be put. As an example the form from the example above can be
written

``
  1
+ x1x2
+ x2x3
+ x3x4
+ x4x5
``

The number of variables of a boolean functions is determined as the
maximum variable number encountered in a boolean function. Note that
this has no consequences on the AI.

Boolean functions are contained in `FILE`. One or more files can
be specified in which case the AI of each boolean function in each
file will be computed and printed to standard output. If `FILE` is
`-` the boolean function is read from standard input. If no file
is given the boolean function is also read from standard input.

==OPTIONS==

> `--version`
  Print the version of `imunal`.

> `-v`
  Print some extra informations before the AIs of the boolean
  functions that follows on the command line.
  The output of `imunal` will be of the form

  ``
  FILE: t1, t2, AI
  ``

  where `t1` indicates the time in seconds taken to compute the fiber
  over `1`, `t2` indicates the time in seconds taken to compute the
  AI, and `AI` is the AI.

> `-q`
  Quiet `imunal`. This option is useful to disable a previous `-v`
  option. This is the default behavior of `imunal`.
  The output of `imunal` will then be of the form

  ``
  FILE: AI
  ``

  where `AI` is the AI.

> `-majority` `n`
  Compute the AI of the majority function in `n` variables.
  Note that majority functions are optimal functions. The AI
  of this function in `n` variables is `ceil(n / 2)`. Note that
  `imunal` actually computes the AI as if it was not known. This
  family of functions can be used to test `imunal`.

==AUTHOR==

`Imunal` and this man page were written by
Guillaume Quintin <quintin@lix.polytechnique.fr>.
