<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
   "http://www.w3.org/TR/html4/strict.dtd">

<!--
This file is part of imunal
Copyright (C) 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
-->

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<title>Documentation of imunal</title>
<meta name="keywords" content="imunal,online,calculator,result">
<meta name="description" content="online calculator for imunal">
<link rel="stylesheet" href="style.css" type="text/css" media="screen">
</head>
<body>

<h1>ONLINE CALCULATOR FOR IMUNAL: RESULT</h1>

<?php

$wrapper = "/users/crypto/quintin/.webdir/imunal/doc/wrapper -v";
$result = "";
$orignal = "";

function popen2($cmd) {
  $handle = popen($cmd,'r');
  $ret = fread($handle,100);
  pclose($handle);
  return $ret;
}

function get_ai_builtin($f) {
  global $wrapper;
  global $original;
  if ( strpos($f,"majority") !== false ) {
    $nvar = substr($f,8);
    return popen2($wrapper." -majority ".$nvar);
  }
  else if ( strpos($f,"hwbf") !== false ) {
    $nvar = substr($f,4);
    return popen2($wrapper." -hwbf ".$nvar);
  }
  $original = "";
  return "unknown";
}

function get_ai($f) {
  global $wrapper;
  global $original;
  if ( strlen($f) > 4096 ) {
    return "You are limited to 4096 characters";
  }
  if ( preg_match('/[^x0-9+\s\n]/',$f) == 1 ) {
    return "Invlid character found: please give a valid".
           " boolean function";
  }
  $original = $f;
  return popen2("echo '".$f."' | ".$wrapper." - 2>&1");
}

if ( isset($_POST["builtin"]) ) {
  $result = get_ai_builtin($_POST["builtin"]);
}

if ( isset($_POST["boolfunc"]) ) {
  $result = get_ai($_POST["boolfunc"]);
}

?>

<p>
Result of the execution of the calculator:
</p>

<pre><code><?php echo $result; ?></code></pre>

<p>
The first number indicates the time in seconds taken to compute the
fiber over <code>1</code>. The second number indicates the time in
seconds taken to compute the AI. And the last number is the AI.
</p>

<?php

if ( $original != "" ) {
  printf("<p>Your function was <code>%s</code>.</p>",
         preg_replace('/[\n\s]+/',' ',$original));
}

?>

<div id="bottom"></div>

<div class="nav_bot">
<p class="nav_return">
<a href="calculator.html">Return to the online calculator</a>
&mdash;
<a href="index.html">Return to main menu</a>
</p>
</div>

</body>
</html>

