/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define NB         (__SZ(gmat_coeff) / 2)
#define WIDTH      (__SZ(gmat_coeff) / NB)

/* matrix cell */
typedef unsigned char gmat_coeff;
const gmat_coeff gempty = ~((gmat_coeff)0u);
const gmat_coeff gundef = 3u;

/* the big matrix */
struct gmat {
  uma ncoeff,n;
  gmat_coeff *coeff;
};

/* a newton is of the form (variable * newton) + newtonS */
struct gnewton {
  uma id,tdeg;
  uma var,right;
  uma nsum,*sum;
};

/* function prototypes */
  /* matrix.c */
PREFIX void gmat_free(struct gmat*);
PREFIX uma gmat_formula(uma);
PREFIX struct gmat *gmat_malloc(uma);
UNUSED PREFIX void gmat_print(FILE*,struct gmat*,uma,struct points*);
  /* newton.c */
UNUSED PREFIX void gnewton_print(FILE*,struct gnewton*,uma);
PREFIX void gnewton_update(struct gnewton*,uma,uma);
PREFIX bit gaff_eval(uma,tuple);
PREFIX bit gnewton_eval2(struct gnewton*,uma,struct points*,uma,
                         struct gmat*,uma);
PREFIX bit gnewton_eval(struct gnewton*,uma,struct points*,uma,
                        struct gmat*,uma);
  /* algo.c */
PREFIX void galgo_xchg(struct gmat*,struct points*,uma,uma);
PREFIX uma galgo_next_lo(uma,uma);
PREFIX uma galgo(struct points*,int);

/* the real code */
#include <greedy_version/matrix.c>
#include <greedy_version/newton.c>
#include <greedy_version/algo.c>

#undef NB
#undef WIDTH
