/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

PREFIX void gmat_free(struct gmat *M) {
  free2(M->coeff);
  free2(M);
}

PREFIX uma gmat_formula(uma i) {
  uma tmp,offset;
  tmp = (i / NB) * sum(NB) + sum(i % NB);
  offset = i + ((sum(i) - tmp) / NB);
  return offset;
}

PREFIX struct gmat *gmat_malloc(uma n) {
  uma ncoeff;
  gmat_coeff *coeff;
  struct gmat *M;

  ncoeff = gmat_formula(n);
  coeff = malloc2(ncoeff * sizeof(gmat_coeff));
  if ( coeff == NULL ) return NULL;
  memset(coeff,gempty,ncoeff * sizeof(gmat_coeff));
  M = malloc2(sizeof(struct gmat));
  if ( M == NULL ) {
    free2(coeff);
    return NULL;
  }
  M->n = n;
  M->ncoeff = ncoeff;
  M->coeff = coeff;
  return M;
}

UNUSED PREFIX void gmat_print(FILE *out,struct gmat *M,uma n,
                              struct points *pts)
{
  uma i,j;
  for( i = 0 ; i < n ; i++ ) {
    uma offset;
    tuple_print(out,pts->pt[i],pts->nvar);
    fputs(": ",out);
    offset = gmat_formula(i);
    for( j = 0 ; j <= i ; j++ ) {
      gmat_coeff coeff;
      coeff = M->coeff[offset + (j / NB)] >> (WIDTH * (j % NB));
      coeff &= MASK(WIDTH);
      fputc((int)coeff + '0',out);
    }
    if ( i < n - 1 ) fputc('\n',out);
  }
}
