/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

UNUSED PREFIX void gnewton_print(FILE *out,struct gnewton *N,uma Nid) {
  uma i;
  fprintf(out,"x%ld*N%ld",(N[Nid].var + 1),(long)(N[Nid].right));
  fputs(" + (",out);
  if ( N[Nid].nsum > 0 ) {
    fprintf(out,"N%ld",(long)N[Nid].sum[0]);
  }
  for( i = 1 ; i < N[Nid].nsum ; i++ ) {
    fprintf(out," + N%ld",(long)N[Nid].sum[i]);
  }
  fputs(")",out);
}

PREFIX void gnewton_update(struct gnewton *N,uma Nid,uma j) {
  struct gnewton *curr;
  curr = &N[Nid];
  curr->sum = adjust2(curr->sum,(curr->nsum + 1) * sizeof(uma));
  curr->sum[curr->nsum] = j;
  curr->nsum++;
}

PREFIX bit gaff_eval(uma var,tuple a) {
  return (a >> var) & one;
}

PREFIX bit gnewton_eval2(struct gnewton *N,uma Nid,
                         struct points *pts,uma ptid,
                         struct gmat *M,uma lo)
{
  uma i;
  bit ret;
  struct gnewton *curr;

  curr = &N[Nid];
  ret = gaff_eval(curr->var,pts->pt[ptid]) &
        gnewton_eval(N,curr->right,pts,ptid,M,lo);
  for( i = 0 ; i < curr->nsum ; i++ ) {
    ret ^= gnewton_eval(N,curr->sum[i],pts,ptid,M,lo);
  }
  return ret;
}

PREFIX bit gnewton_eval(struct gnewton *N,uma Nid,
                       struct points *pts,uma ptid,
                       struct gmat *M,uma lo)
{
  bit ret;
  if ( Nid == 0 ) return one;
  if ( N[Nid].id != noid ) { /* maybe precomputed */
    if ( Nid > ptid ) {
      ret = zero;
    }
    else {
      gmat_coeff c;
      uma offset,shift;
      /*offset = address(M,ptid,Nid) + (Nid / NB);*/
      offset = lo + (Nid / NB);
      shift = WIDTH * (Nid % NB);
      c = M->coeff[offset];
      ret = (((bit)c) >> shift) & MASK(WIDTH);
      if ( ret != gundef ) return ret;
      ret = gnewton_eval2(N,Nid,pts,ptid,M,lo);
      c = M->coeff[offset]; /* NECESSARY */
      c &= ~(MASK(WIDTH) << shift);
      c |= ret << shift;
      M->coeff[offset] = c;
    }
  }
  else {
    ret = gnewton_eval2(N,Nid,pts,ptid,M,lo);
  }
  return ret;
}
