/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

struct points *hwbf_function(int nvar) {
  tuple i,max,*pt,*tmp;
  uma npt;
  struct points *ret;

  max = MASK(nvar);
  pt = malloc((1l << (nvar - 1)) * sizeof(tuple));
  if ( !pt ) return NULL;
  npt = 0;
  for( i = one ; i <= max ; i++ ) {
    if ( (i >> (hamming(i) - 1)) & one ) {
      pt[npt] = i;
      npt++;
    }
  }
  tmp = adjust2(pt,npt * sizeof(tuple));
  if ( !tmp ) {
    free(pt);
    return NULL;
  }
  pt = tmp;
  ret = malloc2(sizeof(struct points));
  if ( !ret ) {
    free(pt);
    return NULL;
  }
  ret->nvar = nvar;
  ret->npt = npt;
  ret->pt = pt;
  return ret;
}
