/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _IMUNAL_H
#define _IMUNAL_H

#include <time.h>
#include <limits.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

/* available graded orders (for now only grlex) */
#define IMUNAL_GRLEX        0

/* available algorithms */
#define IMUNAL_NAIVE_ALGO   1
#define IMUNAL_GREEDY_ALGO  2
#define IMUNAL_NOSWAP_ALGO  3

/* for indexing */
typedef long uma;

/* public types */
typedef unsigned WORD monomial;
typedef unsigned WORD tuple;
typedef unsigned WORD bit;

struct bool_func {
  uma nmo,nvar;
  monomial *mo;
};

struct points {
  uma npt,nvar;
  tuple *pt;
};

struct bool_func_ai_stats {
  clock_t fiber,ai;
  uma mem;
};

/* limits */
#define IMUNAL_NVAR_MAX  ((uma)(sizeof(tuple) * CHAR_BIT - 2))

/* exported functions */
extern void bool_func_print(FILE*,struct bool_func*);
extern struct bool_func *bool_func_read(FILE*);
extern void bool_func_free(struct bool_func*);
extern bit bool_func_eval(struct bool_func*,tuple);
extern struct points *bool_func_get_fiber_over_1(struct bool_func*);
extern int bool_func_get_ai(struct bool_func_ai_stats*,
                            struct bool_func*,int);
extern int bool_func_get_ai_ex(struct bool_func_ai_stats*,
                               struct bool_func*,int,
                               int,unsigned long);
extern int bool_func_get_ai_pts(struct bool_func_ai_stats*,
                                struct points*,int);
extern int bool_func_get_ai_pts_ex(struct bool_func_ai_stats*,
                                   struct points*,int,
                                   int,unsigned long);
extern struct points *majority_function(int);
extern struct points *hwbf_function(int);
extern void points_free(struct points*);

#ifdef __cplusplus
}
#endif

#endif
