/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

PREFIX void *default_malloc(size_t n) {
  void *p;
  p = malloc(n);
  return p;
}

PREFIX void *default_realloc(void *ptr,size_t n) {
  void *p;
  p = realloc(ptr,n);
  return p;
}

PREFIX void *default_calloc(size_t sz,size_t n) {
  void *p;
  p = calloc(sz,n);
  return p;
}

PREFIX void default_free(void *p) {
  free(p);
}

void set_memory_functions(void *(*malloc_func)(size_t),
                          void *(*realloc_func)(void*,size_t),
                          void *(*calloc_func)(size_t,size_t),
                          void (*free_func)(void*))
{
  if ( malloc_func == NULL ) malloc_func = default_malloc;
  if ( realloc_func == NULL ) realloc_func = default_realloc;
  if ( calloc_func == NULL ) calloc_func = default_calloc;
  if ( free_func == NULL ) free_func = default_free;
  malloc2 = malloc_func;
  realloc2 = realloc_func;
  calloc2 = calloc_func;
  free2 = free_func;
}

UNUSED PREFIX void *adjust2(void *p,size_t sz) {
  void *t;
  if ( sz == 0 ) {
    free2(p);
    return NULL;
  }
  if ( p == NULL ) {
    t = malloc2(sz);
  }
  else {
    t = realloc2(p,sz);
  }
  if ( t ) return t;
  return p;
}

UNUSED PREFIX void *memdup2(void *p,size_t sz) {
  void *r;
  if ( sz == 0 || p == NULL ) return NULL;
  r = malloc2(sz);
  if ( !r ) return NULL;
  memcpy(r,p,sz);
  return r;
}

