/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

PREFIX void monomial_print(FILE *out,monomial mo) {
  uma i;
  if ( mo == zero ) {
    fputc('1',out);
    return ;
  }
  for( i = 0 ; i < (uma)(__MONOMIAL) ; i++ ) {
    if ( mo & (one << i) ) {
      fprintf(out,"x%ld",(long)(i + 1));
    }
  }
}

#define VALID_CHAR(c) \
  ((c) == ' ' || (c) == '\n' || c == '\r' || (c) == '\t' || (c) == '+')

PREFIX uma monomial_read(monomial *r,FILE *in) {
  char buf[__MONOMIAL + 1];
  int c;
  uma i,s,var;
  monomial ret;
  
  r[0] = zero;
  for(;;) {
    c = fgetc(in);
    if ( c == EOF ) return -1;
    if ( VALID_CHAR(c) ) continue;
    if ( c == '1' ) {
      r[0] = zero;
      return 0;
    }
    if ( c == 'x' ) break;
    return -2;
  }

  var = 0;
  ret = zero;
  i = 0;
  for(;;) {
    c = fgetc(in);
    if ( c >= '0' && c <= '9' ) {
      buf[i] = c;
      i++;
      if ( i > (uma)__MONOMIAL ) return -2;
      continue;
    }
    if ( !VALID_CHAR(c) && c != EOF && c != 'x' ) return -2;
    buf[i] = 0;
    s = (uma)atol(buf);
    if ( s < 1 || s >= (uma)(__MONOMIAL - 1) ) return -2;
    var = MAX(var,s);
    s--;
    ret |= one << s;
    if ( c != 'x' ) break;
    i = 0;
  }

  r[0] = ret;
  return var;
}

#undef VALID_CHAR

PREFIX uma hamming(monomial a) {
  uma i,w;
  w = 0;
  for( i = 0 ; i < (uma)__MONOMIAL ; i++ ) {
    if ( a & (one << i) ) w++;
  }
  return w;
}

PREFIX monomial monomial_next_grlex(monomial mo,uma nvar) {
  uma i,w,h;
  const monomial mask = MASK(2);

  if ( mo == zero ) return one;
  h = nvar - 1;
  for( i = h - 1 ; i >= 0 && ((mo >> i) & mask) != one ; i-- );
  if ( i < 0 ) return (~zero) >> (__MONOMIAL - hamming(mo) - 1);
  if ( (mo >> h) & one ) {
    w = hamming(mo >> i);
    return (mo & MASK(i)) | (MASK(w) << (i + 1));
  }
  else {
    return mo ^ (mask << i);
  }
}

PREFIX monomial monomial_next(monomial mo,uma nvar,int order) {
  switch(order) {
    case IMUNAL_GRLEX:
    default:
      return monomial_next_grlex(mo,nvar);
  }
}

PREFIX int monomial_cmp_grlex(monomial *pa,monomial *pb) {
  monomial a,b;
  uma wa,wb,i;

  a = pa[0];
  b = pb[0];
  wa = hamming(a);
  wb = hamming(b);
  if ( wa != wb ) return (int)(wa - wb);
  for( i = __MONOMIAL - 1 ; i >= 0 ; i-- ) {
    bit ba,bb;
    ba = (a >> i) & one;
    bb = (b >> i) & one;
    if ( ba == bb ) continue;
    if ( ba == one ) return 1;
    if ( bb == one ) return -1;
  }
  return 0;
}

PREFIX void monomial_quo(uma *var,monomial *r,monomial a,uma nvar) {
  uma i;
  if ( a == zero ) {
    var[0] = -1;
    r[0] = a;
  }
  for( i = 0 ; i < nvar && !((a >> i) & one) ; i++ );
  var[0] = i;
  r[0] = a ^ (one << i);
}

PREFIX bit monomial_eval(monomial mo,tuple a) {
  bit r;
  r = (~(((~mo) | a) - (~zero))) >> (__MONOMIAL - 1);
  return r;
}

