/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

PREFIX void nalgo_xchg(struct nmat *M,struct points *pts,
                       uma i,uma j)
{
  tuple t;
  nmat_coeff c;
  uma k,offseti,offsetj,tmp;

  if ( i == j ) return;
  if ( i > j ) {
    tmp = i;
    i = j;
    j = tmp;
  }
  /* exchange the points */
  t = pts->pt[i];
  pts->pt[i] = pts->pt[j];
  pts->pt[j] = t;
  /* exchange the lines of the matrix */
  offseti = nmat_formula(i,0);
  offsetj = nmat_formula(j,0);
  for( k = 0 ; k <= i ; k++ ) {
    c = M->coeff[offseti + k];
    M->coeff[offseti + k] = M->coeff[offsetj + k];
    M->coeff[offsetj + k] = c;
  }
}

PREFIX uma nalgo_next_lo(uma lo,uma i) {
  return lo + i + 1;
}

PREFIX uma nalgo(struct points *pts,int order) {
  uma i,j,D,u,v,*nnewton_bij,ai,nvar,lo;
  monomial curr,quo;
  struct nnewton *N;
  struct nmat *M;

  /* (nvar = 0) => (boolean function is 1) => (ai = 0) */
  nvar = pts->nvar;
  if ( nvar == 0 ) return 0;

  /* initializations */
    /* sort points */
  points_sort(pts,order);

    /* non malloc'ed vars */
  ai = -1;
  i = 0;
  D = pts->npt;
  curr = zero;
    
    /* bijection: monomial m |--> nnewton with leading monomial m */
  nnewton_bij = calloc2(1 << nvar,sizeof(uma));
  if ( !nnewton_bij ) return -1;
  nnewton_bij[0] = 0;
    
    /* the D nnewtons */  
  N = malloc2(D * sizeof(struct nnewton));
  if ( !N ) goto nalgo_free_nnewton_bij;
  N[0].tdeg = 0;
  N[0].sum = NULL;
  N[0].nsum = 0;

    /* The matrix */
  M = nmat_malloc(D);
  if ( !M ) goto nalgo_free_N;

  /* main loop */
  for( i = 1 ; i < D ; i++ ) {
  
    /* begin construct of the new nnewton */
    curr = monomial_next(curr,nvar,order);
    monomial_quo(&u,&quo,curr,nvar);
    v = nnewton_bij[(unsigned long)quo];
    N[i].id = noid;
    N[i].var = u;
    N[i].right = v;
    N[i].tdeg = N[v].tdeg + 1;
    N[i].sum = NULL;
    N[i].nsum = 0;
  
    /* finish construct of the nnewton: Reduction algorithm */
    lo = nmat_formula(v,0);
    for( j = v ; j < i ; j++ ) {
      if ( nnewton_eval(N,i,pts,j,M,lo) == one ) {
        nnewton_update(N,i,j);
      }
      lo = nalgo_next_lo(lo,j);
    }

    /*
    fprintf(stderr,"N[%ld] = ",(long)i);
    nnewton_print(stderr,N,i);
    fputs("\n\n",stderr);
    */

    /* Here we have found a new nnewton, check if it zeroes on the
       remaining points */
    N[i].id = i;
    lo = nmat_formula(i,0);
    for( j = i ; j < D ; j++ ) {
      if ( nnewton_eval(N,i,pts,j,M,lo) == one ) {
        nalgo_xchg(M,pts,i,j);
        goto nalgo_continue_main_loop;
      }
      lo = nalgo_next_lo(lo,j);
    }
    
    /* Here we are sure that T is an annihilator */
    ai = N[i].tdeg;
    goto nalgo_free_M;
    
nalgo_continue_main_loop:
    N[i].id = i;
    nnewton_bij[(unsigned long)curr] = i;
  }
  
  /* to find a real annihilator, we have to do linear
     algebra but to get the AI there is no need for that */
  ai = hamming(monomial_next(curr,nvar,order));

nalgo_free_M:
  nmat_free(M);

nalgo_free_N:
  for( j = 0 ; j <= i && j < D ; j++ ) {
    if ( N[j].sum ) free2(N[j].sum);
  }
  free2(N);

nalgo_free_nnewton_bij:
  free2(nnewton_bij);

  return ai;
}

