/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

PREFIX void nmat_free(struct nmat *M) {
  free2(M->coeff);
  free2(M);
}

PREFIX uma nmat_formula(uma i,uma j) {
  return sum(i) + j;
}

PREFIX struct nmat *nmat_malloc(uma n) {
  uma ncoeff;
  nmat_coeff *coeff;
  struct nmat *M;

  ncoeff = sum(n);
  coeff = malloc2(ncoeff * sizeof(nmat_coeff));
  if ( !coeff ) return NULL;
  memset(coeff,nundef,ncoeff * sizeof(nmat_coeff));
  M = malloc2(sizeof(struct nmat));
  if ( M == NULL ) {
    free2(coeff);
    return NULL;
  }
  M->n = n;
  M->ncoeff = ncoeff;
  M->coeff = coeff;
  return M;
}

UNUSED PREFIX void nmat_print(FILE *out,struct nmat *M,uma n,
                                struct points *pts)
{
  uma i,j,offset;
  for( i = 0 ; i < n ; i++ ) {
    tuple_print(out,pts->pt[i],pts->nvar);
    fputs(": ",out);
    offset = nmat_formula(i,0);
    for( j = 0 ; j <= i ; j++,offset++ ) {
      fputc((int)(M->coeff[offset]) + '0',out);
    }
    if ( i < n - 1 ) fputc('\n',out);
  }
}
