/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* matrix cell */
typedef unsigned char nmat_coeff;
const nmat_coeff nundef = 3u;

/* the big matrix */
struct nmat {
  uma ncoeff,n;
  nmat_coeff *coeff;
};

/* a newton is of the form (variable * newton) + newtonS */
struct nnewton {
  uma id,tdeg;
  uma var,right;
  uma nsum,*sum;
};

/* function prototypes */
  /* matrix.c */
PREFIX void nmat_free(struct nmat*);
PREFIX uma nmat_formula(uma,uma);
PREFIX struct nmat *nmat_malloc(uma);
UNUSED PREFIX void nmat_print(FILE*,struct nmat*,uma,struct points*);
  /* newton.c */
UNUSED PREFIX void nnewton_print(FILE*,struct nnewton*,uma);
PREFIX void nnewton_update(struct nnewton*,uma,uma);
PREFIX bit naff_eval(uma,tuple);
PREFIX bit nnewton_eval2(struct nnewton*,uma,struct points*,uma,
                         struct nmat*,uma);
PREFIX bit nnewton_eval(struct nnewton*,uma,struct points*,uma,
                        struct nmat*,uma);
  /* algo.c */
PREFIX void nalgo_xchg(struct nmat*,struct points*,uma,uma);
PREFIX uma nalgo_next_lo(uma,uma);
PREFIX uma nalgo(struct points*,int);

/* the real code */
#include <naive_version/matrix.c>
#include <naive_version/newton.c>
#include <naive_version/algo.c>

