/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

PREFIX void salgo_xchg(struct smat *M,struct points *pts,
                       uma i,uma j)
{
  tuple t;
  smat_coeff c;
  uma k,offseti,offsetj,tmp;

  if ( i == j ) return;
  if ( i > j ) {
    tmp = i;
    i = j;
    j = tmp;
  }
  /* exchange the points */
  t = pts->pt[i];
  pts->pt[i] = pts->pt[j];
  pts->pt[j] = t;
  
  /* lines are not in memory */
  if ( i >= M->alloc ) return;

  /* one line is in memory and not the other */
  if ( i < M->alloc && j >= M->alloc ) {
    offseti = smat_formula(i);
    i++;
    for( k = 0 ; k < (i / NB) ; k++ ) {
      M->coeff[offseti + k] = M->buf[k];
    }
    if ( i % NB ) {
      smat_coeff lo2,hi1,mask;
      uma shift;
      shift = WIDTH * (i % NB);
      mask = MASK(shift);
      hi1 = M->coeff[offseti + k] >> shift;
      lo2 = M->buf[k] & mask;
      M->coeff[offseti + k] = lo2 | (hi1 << shift);
    }
    return;
  }
  
  /* exchange the lines of the matrix */
  offseti = smat_formula(i);
  offsetj = smat_formula(j);
  i++;
  for( k = 0 ; k < (i / NB) ; k++ ) {
    c = M->coeff[offseti + k];
    M->coeff[offseti + k] = M->coeff[offsetj + k];
    M->coeff[offsetj + k] = c;
  }
  if ( i % NB ) {
    smat_coeff lo1,lo2,hi1,hi2,mask;
    uma shift;
    shift = WIDTH * (i % NB);
    mask = MASK(shift);
    lo1 = M->coeff[offseti + k] & mask;
    hi1 = M->coeff[offseti + k] >> shift;
    lo2 = M->coeff[offsetj + k] & mask;
    hi2 = M->coeff[offsetj + k] >> shift;
    M->coeff[offseti + k] = lo2 | (hi1 << shift);
    M->coeff[offsetj + k] = lo1 | (hi2 << shift);
  }
}

PREFIX uma salgo_next_lo(uma lo,uma i) {
  uma l;
  l = i + 1;
  return lo + l / NB + ( l % NB ? 1 : 0 );
}

PREFIX uma salgo(struct points *pts,int order,uma mem) {
  uma i,j,D,u,v,*snewton_bij,ai,nvar,lo;
  monomial curr,quo;
  struct snewton *N;
  struct smat *M;

  /* (nvar = 0) => (boolean function is 1) => (ai = 0) */
  nvar = pts->nvar;
  if ( nvar == 0 ) return 0;

  /* initializations */
    /* sort points */
  points_sort(pts,order);

    /* non malloc'ed vars */
  ai = -1;
  i = 0;
  D = pts->npt;
  curr = zero;
  
    /* bijection: monomial m |--> snewton with leading monomial m */
  snewton_bij = calloc2(1 << nvar,sizeof(uma));
  if ( !snewton_bij ) return -1;
  snewton_bij[0] = 0;
    
    /* the D snewtons */  
  N = malloc2(D * sizeof(struct snewton));
  if ( !N ) goto salgo_free_snewton_bij;
  N[0].tdeg = 0;
  N[0].lead = zero;
  N[0].sum = NULL;
  N[0].nsum = 0;

    /* The matrix */
  M = smat_malloc(D,mem);
  if ( !M ) goto salgo_free_N;

  /* main loop */
  for( i = 1 ; i < D ; i++ ) {

    /* begin construct of the new snewton */
    curr = monomial_next(curr,nvar,order);
    monomial_quo(&u,&quo,curr,nvar);
    v = snewton_bij[(unsigned long)quo];
    N[i].lead = curr;
    N[i].id = noid;
    N[i].var = u;
    N[i].right = v;
    N[i].tdeg = N[v].tdeg + 1;
    N[i].sum = NULL;
    N[i].nsum = 0;
 
    /* finish construct of the snewton: Reduction algorithm */
    lo = smat_formula(v);
    for( j = v ; j < i ; j++ ) {
      if ( snewton_eval(N,i,pts,j,M,lo) == one ) {
        snewton_update(N,i,j);
      }
      lo = salgo_next_lo(lo,j);
    }
   
    /* Here we have found a new snewton, check if it zeroes on the
       remaining points */
    N[i].id = i;
    lo = smat_formula(i);
    for( j = i ; j < D ; j++ ) {
      if ( snewton_eval(N,i,pts,j,M,lo) == one ) {
        salgo_xchg(M,pts,i,j);
        goto salgo_continue_main_loop;
      }
      lo = salgo_next_lo(lo,j);
    }
    
    /* Here we are sure that T is an annihilator */
    ai = N[i].tdeg;
    goto salgo_free_M;
    
salgo_continue_main_loop:
    N[i].id = i;
    snewton_bij[(unsigned long)curr] = i;
  }
  
  /* to find a real annihilator, we have to do linear
     algebra but to get the AI there is no need for that */
  ai = hamming(monomial_next(curr,nvar,order));

salgo_free_M:
  smat_free(M);

salgo_free_N:
  for( j = 0 ; j <= i && j < D ; j++ ) {
    if ( N[j].sum ) free2(N[j].sum);
  }
  free2(N);

salgo_free_snewton_bij:
  free2(snewton_bij);

  return ai;
}

