/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

PREFIX void smat_free(struct smat *M) {
  free2(M->coeff);
  free2(M->buf);
  free2(M);
}

PREFIX uma smat_formula(uma i) {
  uma tmp,offset;
  tmp = (i / NB) * sum(NB) + sum(i % NB);
  offset = i + ((sum(i) - tmp) / NB);
  return offset;
}

PREFIX uma smat_ineq(uma M) {
  uma x,x1,x2,y;
  /* find an interval containing the solution */
  for( x1 = 1,x2 = 2 ;
       smat_formula(x2) < M ;
       x1 = x2,x2 = x2 * x2 );
  /* dichotomy to find the solution */
  for( ; x2 - x1 > 1  ; ) {
    x = x1 + (x2 - x1) / 2;
    y = smat_formula(x);
    if ( y > M ) { x2 = x; continue; }
    if ( y < M ) { x1 = x; continue; }
    return x;
  }
  return x1;
}

PREFIX struct smat *smat_malloc(uma n,uma mem) {
  uma ncoeff,alloc,nbuf;
  smat_coeff *coeff,*buf;
  struct smat *M;

  alloc = smat_ineq(mem);
  ncoeff = smat_formula(alloc);
  coeff = malloc2(ncoeff * sizeof(smat_coeff));
  if ( !coeff ) return NULL;
  nbuf = (alloc + 1) / NB + 1;
  buf = malloc2(nbuf * sizeof(smat_coeff));
  if ( !buf ) goto smat_malloc_free_coeff;
  memset(coeff,sempty,ncoeff * sizeof(smat_coeff));
  M = malloc2(sizeof(struct smat));
  if ( !M ) goto smat_malloc_free_buf;
  M->n = n;
  M->ncoeff = ncoeff;
  M->coeff = coeff;
  M->alloc = alloc;
  M->buf = buf;
  M->nbuf = nbuf;
  return M;

smat_malloc_free_buf:
  free2(buf);

smat_malloc_free_coeff:
  free2(coeff);

  return NULL;
}

UNUSED PREFIX void smat_print(FILE *out,struct smat *M,uma n,
                              struct points *pts)
{
  uma i,j;
  for( i = 0 ; i < n ; i++ ) {
    uma offset;
    tuple_print(out,pts->pt[i],pts->nvar);
    fputs(": ",out);
    offset = smat_formula(i);
    for( j = 0 ; j <= i ; j++ ) {
      smat_coeff coeff;
      coeff = M->coeff[offset + (j / NB)] >> (WIDTH * (j % NB));
      coeff &= MASK(WIDTH);
      fputc((int)coeff + '0',out);
    }
    if ( i < n - 1 ) fputc('\n',out);
  }
}
