/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

UNUSED PREFIX void snewton_print(FILE *out,struct snewton *N,uma Nid) {
  uma i;
  if ( N[Nid].lead != NaV ) {
    monomial_print(out,N[Nid].lead);
    return;
  }
  fprintf(out,"x%ld*N%ld",(N[Nid].var + 1),(long)(N[Nid].right));
  fputs(" + (",out);
  if ( N[Nid].nsum > 0 ) {
    fprintf(out,"N%ld",(long)N[Nid].sum[0]);
  }
  for( i = 1 ; i < N[Nid].nsum ; i++ ) {
    fprintf(out," + N%ld",(long)N[Nid].sum[i]);
  }
  fputs(")",out);
}

PREFIX void snewton_update(struct snewton *N,uma Nid,uma j) {
  struct snewton *curr;
  curr = &N[Nid];
  curr->sum = adjust2(curr->sum,(curr->nsum + 1) * sizeof(uma));
  curr->sum[curr->nsum] = j;
  curr->nsum++;
}

PREFIX bit saff_eval(uma var,tuple a) {
  return (a >> var) & one;
}

/********************************************************************
                    the line is in memory 
********************************************************************/

PREFIX bit snewton_eval2_mem(struct snewton *N,uma Nid,
                             struct points *pts,uma ptid,
                             struct smat *M,uma lo)
{
  uma i;
  bit ret;
  struct snewton *curr;

  curr = &N[Nid];
  ret = saff_eval(curr->var,pts->pt[ptid]) &
        snewton_eval_mem(N,curr->right,pts,ptid,M,lo);
  for( i = 0 ; i < curr->nsum ; i++ ) {
    ret ^= snewton_eval_mem(N,curr->sum[i],pts,ptid,M,lo);
  }
  return ret;
}

PREFIX bit snewton_eval_mem(struct snewton *N,uma Nid,
                            struct points *pts,uma ptid,
                            struct smat *M,uma lo)
{
  bit ret;
  if ( Nid == 0 ) return one;
  if ( N[Nid].id != noid ) { /* maybe precomputed */
    if ( Nid > ptid ) {
      ret = zero;
    }
    else {
      smat_coeff c;
      uma offset,shift;
      /*offset = address(M,ptid,Nid) + (Nid / NB);*/
      offset = lo + (Nid / NB);
      shift = WIDTH * (Nid % NB);
      c = M->coeff[offset];
      ret = (((bit)c) >> shift) & MASK(WIDTH);
      if ( ret != sundef ) return ret;
      ret = snewton_eval2_mem(N,Nid,pts,ptid,M,lo);
      c = M->coeff[offset]; /* NECESSARY */
      c &= ~(MASK(WIDTH) << shift);
      c |= ret << shift;
      M->coeff[offset] = c;
    }
  }
  else {
    ret = snewton_eval2_mem(N,Nid,pts,ptid,M,lo);
  }
  return ret;
}

/********************************************************************
      the line is NOT in memory but can hold in the buffer
********************************************************************/

PREFIX bit snewton_eval2_buf(struct snewton *N,uma Nid,
                             struct points *pts,uma ptid,
                             struct smat *M)
{
  uma i;
  bit ret;
  struct snewton *curr;

  curr = &N[Nid];
  ret = saff_eval(curr->var,pts->pt[ptid]) &
        snewton_eval_buf(N,curr->right,pts,ptid,M);
  for( i = 0 ; i < curr->nsum ; i++ ) {
    ret ^= snewton_eval_buf(N,curr->sum[i],pts,ptid,M);
  }
  return ret;
}

PREFIX bit snewton_eval_buf(struct snewton *N,uma Nid,
                            struct points *pts,uma ptid,
                            struct smat *M)
{
  bit ret;
  if ( Nid == 0 ) return one;
  if ( N[Nid].id != noid ) { /* maybe precomputed */
    if ( Nid > ptid ) {
      ret = zero;
    }
    else {
      smat_coeff c;
      uma offset,shift;
      offset = Nid / NB;
      shift = WIDTH * (Nid % NB);
      c = M->buf[offset];
      ret = (((bit)c) >> shift) & MASK(WIDTH);
      if ( ret != sundef ) return ret;
      ret = snewton_eval2_buf(N,Nid,pts,ptid,M);
      c = M->buf[offset]; /* NECESSARY */
      c &= ~(MASK(WIDTH) << shift);
      c |= ret << shift;
      M->buf[offset] = c;
    }
  }
  else {
    ret = snewton_eval2_buf(N,Nid,pts,ptid,M);
  }
  return ret;
}

/********************************************************************
      the line is NOT in memory AND CANNOT hold in the buffer
********************************************************************/

PREFIX bit snewton_eval2_void(struct snewton *N,uma Nid,
                              struct points *pts,uma ptid)
{
  uma i;
  bit ret;
  struct snewton *curr;

  curr = &N[Nid];
  ret = saff_eval(curr->var,pts->pt[ptid]) &
        snewton_eval_void(N,curr->right,pts,ptid);
  for( i = 0 ; i < curr->nsum ; i++ ) {
    ret ^= snewton_eval_void(N,curr->sum[i],pts,ptid);
  }
  return ret;
}

PREFIX bit snewton_eval_void(struct snewton *N,uma Nid,
                             struct points *pts,uma ptid)
{
  if ( Nid == 0 ) return one;
  return snewton_eval2_void(N,Nid,pts,ptid);
}

/********************************************************************
                   which evaluation function?
********************************************************************/

PREFIX bit snewton_eval(struct snewton *N,uma Nid,
                        struct points *pts,uma ptid,
                        struct smat *M,uma lo)
{
  if ( Nid >= M->alloc ) {
    return snewton_eval_void(N,Nid,pts,ptid);
  }
  else if ( ptid >= M->alloc ) {
    memset(M->buf,sempty,M->nbuf * sizeof(smat_coeff));
    return snewton_eval_buf(N,Nid,pts,ptid,M);
  }
  else {
    return snewton_eval_mem(N,Nid,pts,ptid,M,lo);
  }
}

