/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define NB         (__SZ(smat_coeff) / 2)
#define WIDTH      (__SZ(smat_coeff) / NB)

/* matrix cell */
typedef unsigned char smat_coeff;
const smat_coeff sempty = ~((smat_coeff)0u);
const smat_coeff sundef = 3u;

/* the big matrix */
struct smat {
  uma ncoeff,nbuf,n,alloc;
  smat_coeff *coeff,*buf;
};

/* a newton is of the form (variable * newton) + newtonS */
struct snewton {
  uma id,tdeg;
  uma var,right;
  monomial lead;
  uma nsum,*sum;
};

/* function prototypes */
  /* matrix.c */
PREFIX void smat_free(struct smat*);
PREFIX uma smat_formula(uma);
PREFIX struct smat *smat_malloc(uma,uma);
UNUSED PREFIX void smat_print(FILE*,struct smat*,uma,struct points*);
  /* newton.c */
UNUSED PREFIX void snewton_print(FILE*,struct snewton*,uma);
PREFIX void snewton_update(struct snewton*,uma,uma);
PREFIX bit saff_eval(uma,tuple);
PREFIX bit snewton_eval2_mem(struct snewton*,uma,struct points*,uma,
                             struct smat*,uma);
PREFIX bit snewton_eval_mem(struct snewton*,uma,struct points*,uma,
                            struct smat*,uma);
PREFIX bit snewton_eval2_buf(struct snewton*,uma,struct points*,uma,
                             struct smat*);
PREFIX bit snewton_eval_buf(struct snewton*,uma,struct points*,uma,
                            struct smat*);
PREFIX bit snewton_eval2_void(struct snewton*,uma,struct points*,uma);
PREFIX bit snewton_eval_void(struct snewton*,uma,struct points*,uma);
PREFIX bit snewton_eval(struct snewton*,uma,struct points*,uma,
                        struct smat*,uma);
  /* algo.c */
PREFIX void salgo_xchg(struct smat*,struct points*,uma,uma);
PREFIX uma salgo_next_lo(uma,uma);
PREFIX uma salgo(struct points*,int,uma);

/* the real code */
#include <noswap_version/matrix.c>
#include <noswap_version/newton.c>
#include <noswap_version/algo.c>

#undef NB
#undef WIDTH
