/*
 * This file is part of imunal
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <stdio.h>
#include <ram.h>

/********************************************************************
                               LINUX
********************************************************************/
#if defined(linux) || defined(__linux) || defined(__linux__) || \
    defined(__gnu_linux__)
#define FOUND_OS

#include <sys/sysinfo.h>

unsigned long get_ram(void) {
  struct sysinfo info;
  if ( sysinfo(&info) ) return get_ram_error;
  return info.totalram;
}

#endif

/********************************************************************
                              MAC OS
********************************************************************/
#if defined(__APPLE__)
#define FOUND_OS

#include <sys/types.h>
#include <sys/sysctl.h>
#include <stdint.h>

unsigned long get_ram(void) {
  int mib[2];
  size_t len;
  uint64_t memsize;
  
  mib[0] = CTL_HW;
  mib[1] = HW_MEMSIZE;
  len = sizeof(memsize);
  if ( sysctl(mib,2,&memsize,&len,NULL,0) ) return get_ram_error;
  return (unsigned long)memsize;
}

#endif

/********************************************************************
                          NO SYSTEM FOUND
********************************************************************/
#if !defined(FOUND_OS)

unsigned long get_ram(void) {
  return get_ram_error;
}

#endif

