/*
 * This file is part of decoding
 * Copyright 2013  Guillaume Quintin, Olivier Ruatta, Philippe Gaborit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define _POSIX_C_SOURCE 1

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <imunal.h>

void test_bool_func_io(FILE *in,FILE *out) {
  struct bool_func *f;
  f = bool_func_read(in);
  if ( !f ) exit(-1);
  bool_func_print(out,f);
  fputc('\n',out);
}

void test_check_ai(struct points *pts,int ai,const char *filename) {
  int ai1;
  unsigned long mem;

  ai1 = bool_func_get_ai_pts(NULL,pts,IMUNAL_GRLEX);
  if ( ai1 != ai ) {
    fprintf(stdout,">>  %s: TEST FAIL: IMUNAL_GRLEX\n",
            filename);
    fflush(stdout);
    exit(-1);
  }
  ai1 = bool_func_get_ai_pts_ex(NULL,pts,IMUNAL_GRLEX,
                                IMUNAL_NAIVE_ALGO,0);
  if ( ai1 != ai ) {
    fprintf(stdout,">>  %s: TEST FAIL: "
                   "IMUNAL_GRLEX && IMUNAL_NAIVE_ALGO\n",filename);
    fflush(stdout);
    exit(-1);
  }
  ai1 = bool_func_get_ai_pts_ex(NULL,pts,IMUNAL_GRLEX,
                                IMUNAL_GREEDY_ALGO,0);
  if ( ai1 != ai ) {
    fprintf(stdout,">>  %s: TEST FAIL: "
                   "IMUNAL_GRLEX && IMUNAL_GREEDY_ALGO\n",filename);
    fflush(stdout);
    exit(-1);
  }
  for( mem = 32 ; mem <= 1024 * 1024 ; mem = mem * mem ) {
    ai1 = bool_func_get_ai_pts_ex(NULL,pts,IMUNAL_GRLEX,
                                  IMUNAL_NOSWAP_ALGO,mem);
    if ( ai1 != ai ) {
      fprintf(stdout,">>  %s: TEST FAIL: "
                     "IMUNAL_GRLEX && IMUNAL_GREEDY_ALGO "
                     "&& %lu bytes\n",filename,mem);
      fflush(stdout);
      exit(-1);
    }
  }
}

void test_not_enough_memory(FILE *out) {
  fprintf(out,">>  TEST FAIL: not enough memory\n");
  fflush(out);
  exit(-1);
}

void test_bool_func_ai() {
  uma i,max;
  FILE *in;
  char filename[40];
  struct bool_func *f;
  struct points *pts;
  uma good_ai[] = { 1,1,1,1,1,1,1,1,
                    1,1,1,1,1,1,1,1,
                    1,1,1,1,2        };
  
  max = sizeof(good_ai) / sizeof(good_ai[0]);
  for( i = 1 ; i <= max ; i++ ) {
    sprintf(filename,"tests/func%ld",(long)i);
    in = fopen(filename,"r");
    if ( !in ) test_not_enough_memory(stdout);
    f = bool_func_read(in);
    if ( !f ) test_not_enough_memory(stdout);
    fclose(in);
    pts = bool_func_get_fiber_over_1(f);
    if ( !pts ) test_not_enough_memory(stdout);
    test_check_ai(pts,good_ai[i - 1],filename);
    points_free(pts);
  }
  for( i = 4 ; i <= 8 ; i++ ) {
    pts = majority_function(i);
    if ( !pts ) test_not_enough_memory(stdout);
    sprintf(filename,"majority function in %ld variables",(long)i);
    test_check_ai(pts,(i / 2 + (i % 2)),filename);
    points_free(pts);
  }
}

int main(int argc,char **argv) {
  if ( argc != 2 ) return -1;
  if ( !strcmp(argv[1],"bool_func_io") ) {
    test_bool_func_io(stdin,stdout);
  }
  else if ( !strcmp(argv[1],"bool_func_ai") ) {
    test_bool_func_ai();
  }
  return 0;
}
